% clear all; clc;

% rng(0);

N = 256;            % Port number
f_c = 3.5e9;        % Frequency

Lambda = 3e8/f_c;   % Wavelength

L = 9;              % Path number

W = [10:5:50];             % Aperture length per wavelength

Rep = 1000;

for w = 1:length(W)
    x = linspace(0,W(w)*Lambda,N)';
    Kernal_SV_mean = zeros(N,N);
    parfor rp = 1:Rep
        h = SV_channel(x,Lambda,L);
        Kernal_SV_mean = Kernal_SV_mean + h*h';
    end
    Kernal_SV_mean = Kernal_SV_mean/Rep;
    save(['SV_Kernal_W_' num2str(W(w)) '.mat'],'N','x','Kernal_SV_mean');
end


